function [ ] = Krish_Radial_Plot(dt, Ntri, Nodes, spline, direction )
%Plot the spline radially along the unit direction of given vector.
%   direction given as a row vector.

%By uncommenting code can simplify the user input if choose 
%direction = [[1,0]];
Length = sqrt(direction*direction');
u = direction/Length;

r = 0:.001:.998;
y = zeros(1,999);
for i = 1:999
    y(1,i) = QSpline_Eval(dt,Q_FNodal(Ntri,Nodes,spline), r(1,i)*u);
end
y = y';

State_Hold = input('Are you plotting on an already held figure? No(0), Yes(1):');

Color = input('What color would you like the plot? Black(1), Blue(2), Red(3):');
if Color == 1
    plot(r(1,1:501),y(1:501,1),'k','LineWidth',2) %[0.5] radial interval
    if State_Hold == 0 %If no pre-existing plot then hold the one just 
        hold           %generated, so don't lose the [0,.5] interval
    end
    plot(r(1,502:999),y(502:999,1),'k:','LineWidth',2) %[.5,1] radial interval
elseif Color == 2
    plot(r(1,1:501),y(1:501,1),'b','LineWidth',2)
    if State_Hold == 0
        hold
    end
    plot(r(1,502:999),y(502:999,1),'b:','LineWidth',2)
else 
    plot(r(1,1:501),y(1:501,1),'r','LineWidth',2)
    if State_Hold == 0
        hold
    end
    plot(r(1,502:999),y(502:999,1),'r:','LineWidth',2)
end
if State_Hold == 0
        hold
end


end

